//
//		Definition of the main game class
//
#ifndef THE_MAIN_SCENE_H
#define THE_MAIN_SCENE_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#include "../Tools/DebuggerInterface.h"
#include "../Utils/theStringManager.h"
#include "../Villagers/Villager.h"

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theButterflyClass;
class theRealtimeManager;
class theStringManager;
class theFernsaceDialog;



class theMainScene : public ldwScene, IDebugger
{
private:

	typedef void (theMainScene::* LPBUTTONHANDLER)(void);

	//class enumerations
	enum EButton
	{
		eButton_None = -1,

		eButton_Menu,
		eButton_VillagerDetails,
		eButton_Tech,
		eButton_Overview,
		eButton_Collection,
		eButton_Puzzles,
		eButton_LastTip,

		eButton_NumberOf
	};

	//class data
	static theMainScene *	m_pInstance;

	//class methods
	//setup
	private:	theMainScene();
	private:	~theMainScene();
	public:		static theMainScene *Get();
	public:		static theMainScene &Ref();
	public:		static void Destroy();

	public:		bool HandleKey(int messageId,int keyCode,int character);
	public:		bool HandleMouse(int messageId,ldwPoint location);
	public:		bool HandleMessage(int messageId,long data);

protected:

	void Activate(bool active);
	void Debug();
	void DrawScene();
	void UpdateScene();
	void DrawUI();

	public:		const bool HandleKeyCharacter(const char cKey);
	public:		const bool HandleKeyDown(const int iKeyCode);
	public:		const bool HandleKeyUp(const int iKeyCode);
	public:		const bool HandleMouseDown(const ldwPoint sMousePos);
	public:		const bool HandleMouseUp(const ldwPoint sMousePos);
	public:		const bool HandleMouseMove(const ldwPoint sMousePos);

	void HandleMenuButton();
	void HandleVillagerDetailsButton();
	void HandleTechButton();
	void HandleOverviewButton();
	void HandleCollectionButton();
	void HandlePuzzlesButton();
	void HandleLastTipButton();

	void HandleMapClick(const ldwPoint sPos);
	const bool HandleDropOnHotSpot(CVillager &Villager);
	void HandleDropOnVillager(CVillager &Villager);
	void DropVillager();
	void SayCurrentContent(const ldwPoint sFeetPos);
	void MapClickFeedback(const ldwPoint sPos);

private:

	ldwGameWindow *gameWindow;
	theGameState  *gs;
	theRealtimeManager *realtimeManager;
	theStringManager *stringMgr;

	ldwPoint m_sDragPos;

	ldwUINT32 secondTimer;

	ldwPoint tutorialMouse;
	ldwPoint clickPoint;

	int tutorialCounter;

	int currentTipDebug;

	int cheatCode;

	bool showContent;
	//int clothingConfirmRequest;

	bool villagerClick;

	bool dragging;
	int inHand;

	ldwRect blitRect;
	ldwRect displayRect;
	ldwRect schoolDrumRect;
	ldwRect tipRect;

	ldwPoint handPos;

	ldwImage *mainBG;
	ldwImage *hand;
	ldwImage *handOpen;

	ldwButton	   *menuButton;
	ldwButton	   *villagerButton;
	ldwButton	   *techButton;
	ldwButton		*overviewButton;
	ldwButton		*puzzlesButton;
	ldwButton		*collectionsButton;

	ldwButton  *lastTipButton;
	bool        mLastTipButtonShowing;


	ldwTextControl *popLabel;
	ldwTextControl *popField;
	ldwTextControl *foodLabel;
	ldwTextControl *foodField;
	ldwTextControl *techLabel;
	ldwTextControl *techField;
	ldwTextControl *nameLabel;
	ldwTextControl *nameField;
	ldwTextControl *skillLabel;
	ldwTextControl *skillField;
	ldwTextControl *actionLabel;
	ldwTextControl *actionField;
	ldwTextControl *playerCommField;
};
#endif